<?php

// Crear el menú de configuración
function aloja360_admin_menu() {
    $hook = add_options_page(
        'Configuración de Aloja360',
        'Aloja360',
        'manage_options',
        'aloja360',
        'aloja360_admin_page'
    );

    add_action("admin_print_scripts-$hook", 'enqueue_aloja360_admin_scripts');
}
add_action('admin_menu', 'aloja360_admin_menu');


function enqueue_aloja360_admin_scripts() {
    wp_enqueue_script('aloja360_admin_settings', plugins_url('admin-settings.js', __FILE__), array('jquery'), '1.0.0', true);
}

// Crear la página de configuración
function aloja360_admin_page() {
    // Enlace al archivo de estilos CSS
    echo '<link rel="stylesheet" type="text/css" href="' . plugins_url('admin-styles.css', __FILE__) . '">';
    ?>
    <div class="wrap">
        <h1>Configuración de Aloja360</h1>
      
        <img src="<?php echo plugins_url('img/aloja360.png', dirname(__FILE__)); ?>" width="260" alt="Aloja 360" />
         <div class="plugin-description">
            <p>Este es un plugin personalizado para integrar funcionalidades de Aloja360 en WordPress. Introduce las claves en los campos de abajo:</p>
        </div>
        <form method="post" action="options.php">
            <?php
            settings_fields('aloja360_options');
            do_settings_sections('aloja360');
            submit_button();
            ?>
        </form>
         
</div>
    </div>


    <?php
}

function aloja360_settings_init() {
    register_setting('aloja360_options', 'aloja360_options');

    add_settings_section(
        'aloja360_keys_section',
        'Claves de Configuración',
        '',
        'aloja360'
    );

    add_settings_field(
        'aloja360_keyg',
        'KeyG',
        'aloja360_keyg_cb',
        'aloja360',
        'aloja360_keys_section'
    );

    add_settings_field(
        'aloja360_keya',
        'KeyA',
        'aloja360_keya_cb',
        'aloja360',
        'aloja360_keys_section'
    );

    add_settings_field(
        'aloja360_keyc',
        'KeyC',
        'aloja360_keyc_cb',
        'aloja360',
        'aloja360_keys_section'
    );

    // Añade un nuevo campo oculto para rastrear el número de KeyA agregados
    add_settings_field(
        'aloja360_keya_count',
        '',
        'aloja360_keya_count_cb',
        'aloja360',
        'aloja360_keys_section'
    );
}


add_action('admin_init', 'aloja360_settings_init');

// Callback para el campo KeyA Count (oculto)
function aloja360_keya_count_cb() {
    $options = get_option('aloja360_options');
    $keya = isset($options['keya']) ? $options['keya'] : array();
    echo '<input type="hidden" id="aloja360_keya_count" name="aloja360_options[keya_count]" value="' . count($keya) . '">';
}

// Callbacks para los campos de las claves
function aloja360_keyg_cb() {
    $options = get_option('aloja360_options');
    echo '<input type="text" id="aloja360_keyg" name="aloja360_options[keyg]" value="' . esc_attr($options['keyg']) . '" size=40>';
}

// Callback para el campo KeyA
function aloja360_keya_cb() {
    $options = get_option('aloja360_options');
    $keya = isset($options['keya']) ? $options['keya'] : array();

    echo '<div id="aloja360_keya_container">'; // Inicio del contenedor de KeyA

    if (!empty($keya)) {
        $index = 0;
        foreach ($keya as $value) {
            ?>
            <div id="aloja360_keya_<?php echo $index; ?>" class="aloja360_keya_item">
                <input type="text" name="aloja360_options[keya][<?php echo $index; ?>][name]" value="<?php echo esc_attr($value['name']); ?>" placeholder="Nombre">
                <input type="text" name="aloja360_options[keya][<?php echo $index; ?>][value]" value="<?php echo esc_attr($value['value']); ?>" placeholder="KeyA" size=40>
                <button type="button" class="remove_keya">Eliminar</button>
                <p></p>
                <code>[aloja360 keya="<?php echo esc_attr($value['name']); ?>"]</code>
                <br /><br />
            </div>
            <?php
            $index++;
        }
    } else {
        ?>
        <div id="aloja360_keya_0" class="aloja360_keya_item">
            <input type="text" name="aloja360_options[keya][0][name]" placeholder="Nombre">
            <input type="text" name="aloja360_options[keya][0][value]" placeholder="KeyA" size=40>
            <button type="button" class="remove_keya">Eliminar</button>
            <p></p>
            <code>[aloja360 keya=""]</code>
            <br /><br />
        </div>
        <?php
    }

    echo '</div>'; // Fin del contenedor de KeyA

    ?>
    <button type="button" class="add_keya">Añadir KeyA</button>

    <script>
        jQuery(document).ready(function($) {
            // Manejador de eventos para agregar un nuevo KeyA
            $('.add_keya').on('click', function() {
                var index = $('.aloja360_keya_item').length;
                var html = `
                    <div id="aloja360_keya_${index}" class="aloja360_keya_item">
                        <input type="text" name="aloja360_options[keya][${index}][name]" placeholder="Nombre">
                        <input type="text" name="aloja360_options[keya][${index}][value]" placeholder="KeyA" size=40>
                        <button type="button" class="remove_keya">Eliminar</button>
                        <p></p>
                        <code>[aloja360 keya=""]</code>
                        <br /><br />
                    </div>
                `;
                $('#aloja360_keya_container').append(html);
            });

            // Manejador de eventos para eliminar un KeyA
            $(document).on('click', '.remove_keya', function() {
                $(this).closest('.aloja360_keya_item').remove();
            });
        });
    </script>
    <?php
}





function aloja360_keyc_cb() {
    $options = get_option('aloja360_options');
    echo '<input type="text" id="aloja360_keyc" name="aloja360_options[keyc]" value="' . esc_attr($options['keyc']) . '" size=40>';
}

// Función para validar las opciones
function aloja360_validate_options($input) {
    // Validar los campos antes de guardar las opciones
    if (isset($input['keya'])) {
        $input['keya'] = array_values(array_filter($input['keya'], 'aloja360_validate_keya'));
    }
    return $input;
}

// Función para validar un campo KeyA
function aloja360_validate_keya($value) {
    // Validar el campo KeyA aquí si es necesario
    return $value;
}

