var aloja360_keya_count = 0; // Inicializa el contador fuera de las funciones

function add_keya() {
    var html = '<div id="aloja360_keya_' + aloja360_keya_count + '">';
    html += '<input type="text" name="aloja360_options[keya][' + aloja360_keya_count + '][name]" placeholder="Nombre">';
    html += '<input type="text" name="aloja360_options[keya][' + aloja360_keya_count + '][value]" placeholder="KeyA">';
    html += '<button type="button" onclick="remove_keya(' + aloja360_keya_count + ');">Eliminar</button><p>&nbsp;</p>';
    html += '</div>';
    jQuery('#aloja360_keya_container').append(html);
    aloja360_keya_count++;
}

function remove_keya(id) {
    jQuery('#aloja360_keya_' + id).remove();
}

jQuery(document).ready(function($) {
    // Recupera el contador de KeyA al cargar la página
    var keyaCount = parseInt($('#aloja360_keya_count').val()) || 0;

    // Actualiza el contador de KeyA al agregar o eliminar elementos
    function updateKeyaCount() {
        keyaCount = $('.aloja360_keya_item').length;
        $('#aloja360_keya_count').val(keyaCount);
    }

    // Añade el atributo "data-keya" al botón Eliminar para identificar el elemento correspondiente
    $('.aloja360_keya_item button').attr('data-keya', function(index) {
        return index;
    });

    // Manejador de eventos para agregar un nuevo KeyA
    $('.aloja360_keya_add').on('click', function() {
        var index = keyaCount;
        var itemHtml = `
            <div class="aloja360_keya_item">
                <input type="text" name="aloja360_options[keya][${index}][name]" placeholder="Nombre">
                <input type="text" name="aloja360_options[keya][${index}][value]" placeholder="KeyA" size="40">
                <button type="button" class="aloja360_keya_remove" data-keya="${index}">Eliminar</button>
                <p></p>
                <code>[aloja360 keya=""]</code>
                <br /><br />
            </div>
        `;
        $('.aloja360_keya_container').append(itemHtml);
        keyaCount++;
        $('#aloja360_keya_count').val(keyaCount);
    });

    // Manejador de eventos para eliminar un KeyA
    $(document).on('click', '.aloja360_keya_remove', function() {
        var keyaIndex = $(this).attr('data-keya');
        $(this).closest('.aloja360_keya_item').remove();
        updateKeyaCount();
    });
});
